//
//  MCProtocolStateMachine.h
//  MCNetComm
//
//  Created by Brent Gulanowski on 26/03/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


@class MCProtocolState;

@interface MCProtocolStateMachine : NSObject {

	NSString *name;
	MCProtocolState *startState;
	MCProtocolState *currentState;
	NSDictionary *allStates;
}


#if MAC_OS_X_VERSION_MAX_ALLOWED <= MAC_OS_X_VERSION_10_4
- (NSString *)name;
- (void)setName:(NSString *)aName;
- (NSArray *)stateNames;
- (NSString *)currentStateName;
#else
@property (readwrite, copy) NSString *name;
@property (readonly, copy) NSArray *stateNames;
@property (readonly, copy) NSString *currentStateName;
#endif

+ (id)machineWithFileName:(NSString *)plistFile;

- (id)initWithFileName:(NSString *)plistFile;

- (NSArray *)validNextStatesForState:(NSString *)stateName;
- (NSString *)activeParticipantForState:(NSString *)stateName;

// state machine work
- (BOOL)moveToState:(NSString *)stateName;

- (void)reset;
- (BOOL)isReset; // i.e.: current state is the start state
- (BOOL)hasRejected;
- (BOOL)hasAccepted;
- (BOOL)isProcessing;

@end
